/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.InDevelopment;

import util.interfaces.Function;

public class Cycle<T> {
    private T state;
    private Function<T, T> next;
    Integer size = null;

    public Cycle(Function<T, T> f, T initial_state) {
        this.next = f;
        this.state = initial_state;
    }

    public T getState() {
        return this.state;
    }

    public T getNextState() {
        this.cycle();
        return this.state;
    }

    public void cycle() {
        this.state = this.next.eval(this.state);
    }

    public T cycle(T state_in) {
        return this.next.eval(state_in);
    }

    public T cycle(T state_in, int times) {
        if (times < 0) {
            throw new Error("Cycles do not know how to go backwards yet!");
        }
        T output = state_in;
        int i = 0;
        while (i < times) {
            output = this.next.eval(output);
            ++i;
        }
        return output;
    }

    public int size() {
        if (this.size == null) {
            this.size = this.computeSize(this.state);
        }
        return this.size;
    }

    private int computeSize(T state) {
        int size = 0;
        T tortoise = state;
        T hare = state;
        do {
            tortoise = this.cycle(tortoise, 2);
            hare = this.cycle(hare);
            ++size;
        } while (!tortoise.equals(hare));
        return size;
    }
}

